unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    BitBtn2: TBitBtn;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    BitBtn3: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit4Exit(Sender: TObject);
    function FPresent(name: string): boolean;
    function ScanMax(s: string): boolean;
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Max: integer;

implementation

{$R *.DFM}

function tform1.FPresent(name: string): boolean;
var
   searchrec: tsearchrec;

begin
   fpresent:=false;
   if name<>'' then begin
      if (findfirst(name, faanyfile, searchrec)=0) and
         (searchrec.size>0) then begin
         edit2.text:='0';
         max:=searchrec.size-1;
         edit3.text:=inttostr(max);
         edit2.enabled:=true;
         edit3.enabled:=true;
         if edit4.text<>'' then
            bitbtn3.enabled:=true
         else
            bitbtn3.enabled:=false;
         fpresent:=true;
      end
      else begin
         edit2.enabled:=false;
         edit3.enabled:=false;
         bitbtn3.enabled:=false;
      end;
   end;
end;

function tform1.ScanMax(s: string): boolean;
var
   n: integer;

begin
   n:=strtoint(s);
   if n>max then
      result:=false
   else
      result:=true;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
   if opendialog1.execute then begin
      edit1.text:=opendialog1.FileName;
      fpresent(opendialog1.FileName);
   end;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
   if savedialog1.execute then begin
      edit4.text:=savedialog1.FileName;
      if edit1.text<>'' then
         bitbtn3.enabled:=true
      else
         bitbtn3.enabled:=false;
   end;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
   if edit1.text<>'' then begin
      edit2.enabled:=true;
      edit3.enabled:=true;
      if edit4.text<>'' then
         bitbtn3.enabled:=true
      else
         bitbtn3.enabled:=false;
   end
   else begin
      edit2.enabled:=false;
      edit3.enabled:=false;
      bitbtn3.enabled:=false;
   end;
end;

procedure TForm1.Edit4Exit(Sender: TObject);
begin
   if (edit4.text<>'') and (edit1.text<>'') then
      bitbtn3.enabled:=true
   else
      bitbtn3.enabled:=false;
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
   if not (key in ['0'..'9']) and (key<>#8) then
      key:=#27;
end;

procedure TForm1.Edit3KeyPress(Sender: TObject; var Key: Char);
begin
   if not (key in ['0'..'9']) and (key<>#8) then
      key:=#27;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
   if not scanmax(edit2.text) then
      edit2.Text:=inttostr(max);
end;

procedure TForm1.Edit3Exit(Sender: TObject);
var
   n: integer;

begin
   n:=strtoint(edit2.text);
   if not scanmax(edit3.text) then
      edit3.Text:=inttostr(max)
   else
   if strtoint(edit3.text)<n then
      edit3.Text:=edit2.text;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
var
   s, d: tfilestream;
   n: integer;

begin
   bitbtn3.enabled:=false;

   s:=tfilestream.create(edit1.text, fmopenread);
   d:=tfilestream.create(edit4.text, fmopenwrite or fmcreate);
   s.Seek(strtoint(edit2.text), soFromBeginning);
   n:=strtoint(edit3.text)-strtoint(edit2.text)+1;
   d.copyfrom(s, n);
   d.free;
   s.free;

   showmessage(inttostr(n)+' byte(s) is copyed');
   bitbtn3.enabled:=true;
end;

end.
