unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  mydt: tdatetime;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  mydt:=now;
  edit2.Text:=floattostr(mydt);
end;

procedure TForm1.Edit2Change(Sender: TObject);
var
  error: boolean;

begin
  if edit1.Focused then
    exit;
  error:=false;
  try
    mydt:=strtofloat(edit2.text);
  except
    on EConvertError do
      error:=true;
  end;
  if not error then
    edit1.text:=datetimetostr(mydt)
  else
    edit1.text:='';
end;

procedure TForm1.Edit1Change(Sender: TObject);
var
  error: boolean;

begin
  if edit2.Focused then
    exit;
  error:=false;
  try
    mydt:=strtodatetime(edit1.text);
  except
    on EConvertError do
      error:=true;
  end;
  if not error then
    edit2.Text:=floattostr(mydt)
  else
    edit2.text:='';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  mydt:=now;
  edit2.Text:=floattostr(mydt);
end;

end.
