// MyThread.cpp :	thread for View Memory
// Title :			Memory tester
// Version :		See Version Information (VS_VERSION_INFO Resource)
// Author :			Pavel Korolov, St.-Petersburg
// Beginning :		20 feb 1999
// Modified :		See system date of this file 
// Note :			The program and source text can be used by you freely

#include "stdafx.h"
#include "Memory.h"
#include "MyThread.h"
#include "MemoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class CMemoryDlg;

/////////////////////////////////////////////////////////////////////////////
// CMyThread

IMPLEMENT_DYNCREATE(CMyThread, CWinThread)

// starting parameters
CMyThread::CMyThread()
{	m_bDone = FALSE;
	m_pOwner = NULL;
	m_bAutoDelete = TRUE;
}

CMyThread::~CMyThread()
{
}

BOOL CMyThread::InitInstance()
{
	// TODO:  perform and per-thread initialization here
	return TRUE;
}

int CMyThread::ExitInstance()
{
	// TODO:  perform any per-thread cleanup here
	return CWinThread::ExitInstance();
}

// working function
int CMyThread::Run()
{	MEMORYSTATUS PrevInfo;
	MEMORYSTATUS Info;
	CString s;

	if (m_pOwner == NULL)
		return -1;

	// "clear" prevision information
	memset(&PrevInfo, 0xff, sizeof(PrevInfo));

	while (!m_bDone)
	{	// get of current memory information
		Info.dwLength=sizeof(Info);
		GlobalMemoryStatus(&Info);

		// view of phisical memory
		if (Info.dwTotalPhys!=PrevInfo.dwTotalPhys)
		{	s.Format("%d", Info.dwTotalPhys);
			AddPoint(s);
			m_pOwner->m_TotalPhisical.SetWindowText(s);
		}
		if (Info.dwAvailPhys!=PrevInfo.dwAvailPhys)
		{	s.Format("%d", Info.dwAvailPhys);
			AddPoint(s);
			m_pOwner->m_FreelyPhisical.SetWindowText(s);
		}

		// view of page file memory
		if (Info.dwTotalPageFile!=PrevInfo.dwTotalPageFile)
		{	s.Format("%d", Info.dwTotalPageFile);
			AddPoint(s);
			m_pOwner->m_TotalPageFile.SetWindowText(s);
		}
		if (Info.dwAvailPageFile!=PrevInfo.dwAvailPageFile)
		{	s.Format("%d", Info.dwAvailPageFile);
			AddPoint(s);
			m_pOwner->m_FreelyPageFile.SetWindowText(s);
		}

		// view of virtual memory
		if (Info.dwTotalVirtual!=PrevInfo.dwTotalVirtual)
		{	s.Format("%d", Info.dwTotalVirtual);
			AddPoint(s);
			m_pOwner->m_TotalVirtual.SetWindowText(s);
		}
		if (Info.dwAvailVirtual!=PrevInfo.dwAvailVirtual)
		{	s.Format("%d", Info.dwAvailVirtual);
			AddPoint(s);
			m_pOwner->m_FreelyVirtual.SetWindowText(s);
		}

		// save current information
		PrevInfo=Info;
	}
	m_pOwner->PostMessage(WM_CLOSE, 0, 0L);
	return 0;
}

// add points in view field
void CMyThread::AddPoint(CString &s)
{	if (s.GetLength()<=3)
		return;
	for (int i=s.GetLength()-3; i>0; i=i-3)
		s.Insert(i, ".");
}

BEGIN_MESSAGE_MAP(CMyThread, CWinThread)
	//{{AFX_MSG_MAP(CMyThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyThread message handlers
