// MemoryDlg.h : header file
//

#if !defined(AFX_MEMORYDLG_H__27D47EC7_C8E1_11D2_87EB_444553540000__INCLUDED_)
#define AFX_MEMORYDLG_H__27D47EC7_C8E1_11D2_87EB_444553540000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// define ------------------------------------------------------
class CMyThread;
class CMemoryDlg;

typedef struct
{	BYTE		*Mem;
	UINT		Size;
	CWinThread	*Thread;
	UINT		Sec;
	UINT		Result;
	BOOL		ManualExit;
	CMemoryDlg	*Dialog;
	WPARAM		Param;
} TTest;

#define WM_STOPTEST WM_USER+1

/////////////////////////////////////////////////////////////////////////////
// CMemoryDlg dialog

class CMemoryDlg : public CDialog
{
// Construction
public:
	HGLOBAL m_hGlobalAlloc;
	TTest	m_TestGlobalAlloc;

	LPVOID	m_pVirtualAlloc;
	TTest	m_TestVirtualAlloc;

	HANDLE	m_hFileMapping;
	TTest	m_TestFileMapping;

	CMyThread *m_MyThread;

	BOOL ErrorMessage(int h, char *ch, BOOL ErrorNULL=TRUE);
	void TestMem(TTest *Test);

	CMemoryDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CMemoryDlg)
	enum { IDD = IDD_MEMORY_DIALOG };
	CButton	m_FileMappingTest;
	CButton	m_FileMappingUse;
	CButton	m_FileMappingReserve;
	CButton	m_VirtualAllocTest;
	CButton	m_VirtualAllocUse;
	CButton	m_VirtualAllocReserve;
	CSpinButtonCtrl	m_TestSecSpin;
	CButton	m_GlobalAllocTest;
	CButton	m_GlobalAllocUse;
	CButton	m_GlobalAllocReserve;
	CEdit	m_WorkFileMapping;
	CEdit	m_WorkGlobalAlloc;
	CEdit	m_FreelyVirtual;
	CEdit	m_TotalVirtual;
	CEdit	m_TotalPageFile;
	CEdit	m_FreelyPhisical;
	CEdit	m_TotalPhisical;
	CEdit	m_FreelyPageFile;
	CEdit	m_WorkVirtualAlloc;
	UINT	m_nTestSec;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMemoryDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CMemoryDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnChangeGlobalAlloc();
	afx_msg void OnGlobalAllocReserve();
	afx_msg void OnGlobalAllocTest();
	afx_msg void OnGlobalAllocUse();
	afx_msg LRESULT OnFinishTest(WPARAM wParam, LPARAM lParam);
	afx_msg void OnVirtualAllocReserve();
	afx_msg void OnVirtualAllocUse();
	afx_msg void OnVirtualAllocTest();
	afx_msg void OnChangeVirtualAlloc();
	afx_msg void OnFileMappingReserve();
	afx_msg void OnChangeFileMapping();
	afx_msg void OnFileMappingTest();
	afx_msg void OnFileMappingUse();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.


#endif // !defined(AFX_MEMORYDLG_H__27D47EC7_C8E1_11D2_87EB_444553540000__INCLUDED_)
