// MemoryDlg.cpp :	implementation file
// Title :			Memory tester
// Version :		See Version Information (VS_VERSION_INFO Resource)
// Author :			Pavel Korolov, St.-Petersburg
// Beginning :		20 feb 1999
// Modified :		See system date of this file 
// Note :			The program and source text can be used by you freely

#include "stdafx.h"
#include "Memory.h"
#include "MemoryDlg.h"
#include "MyThread.h"
#include "AboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMemoryDlg dialog

CMemoryDlg::CMemoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemoryDlg)
	m_nTestSec = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
 	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMemoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemoryDlg)
	DDX_Control(pDX, IDC_BUTTON8, m_FileMappingTest);
	DDX_Control(pDX, IDC_BUTTON7, m_FileMappingUse);
	DDX_Control(pDX, IDC_BUTTON12, m_FileMappingReserve);
	DDX_Control(pDX, IDC_BUTTON6, m_VirtualAllocTest);
	DDX_Control(pDX, IDC_BUTTON5, m_VirtualAllocUse);
	DDX_Control(pDX, IDC_BUTTON11, m_VirtualAllocReserve);
	DDX_Control(pDX, IDC_SPIN1, m_TestSecSpin);
	DDX_Control(pDX, IDC_BUTTON2, m_GlobalAllocTest);
	DDX_Control(pDX, IDC_BUTTON1, m_GlobalAllocUse);
	DDX_Control(pDX, IDC_BUTTON9, m_GlobalAllocReserve);
	DDX_Control(pDX, IDC_EDIT10, m_WorkFileMapping);
	DDX_Control(pDX, IDC_EDIT7, m_WorkGlobalAlloc);
	DDX_Control(pDX, IDC_EDIT6, m_FreelyVirtual);
	DDX_Control(pDX, IDC_EDIT3, m_TotalVirtual);
	DDX_Control(pDX, IDC_EDIT2, m_TotalPageFile);
	DDX_Control(pDX, IDC_EDIT4, m_FreelyPhisical);
	DDX_Control(pDX, IDC_EDIT1, m_TotalPhisical);
	DDX_Control(pDX, IDC_EDIT5, m_FreelyPageFile);
	DDX_Control(pDX, IDC_EDIT9, m_WorkVirtualAlloc);
	DDX_Text(pDX, IDC_EDIT11, m_nTestSec);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemoryDlg, CDialog)
	//{{AFX_MSG_MAP(CMemoryDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT7, OnChangeGlobalAlloc)
	ON_BN_CLICKED(IDC_BUTTON9, OnGlobalAllocReserve)
	ON_BN_CLICKED(IDC_BUTTON2, OnGlobalAllocTest)
	ON_BN_CLICKED(IDC_BUTTON1, OnGlobalAllocUse)
	ON_MESSAGE(WM_STOPTEST, OnFinishTest)
	ON_BN_CLICKED(IDC_BUTTON11, OnVirtualAllocReserve)
	ON_BN_CLICKED(IDC_BUTTON5, OnVirtualAllocUse)
	ON_BN_CLICKED(IDC_BUTTON6, OnVirtualAllocTest)
	ON_EN_CHANGE(IDC_EDIT9, OnChangeVirtualAlloc)
	ON_BN_CLICKED(IDC_BUTTON12, OnFileMappingReserve)
	ON_EN_CHANGE(IDC_EDIT10, OnChangeFileMapping)
	ON_BN_CLICKED(IDC_BUTTON8, OnFileMappingTest)
	ON_BN_CLICKED(IDC_BUTTON7, OnFileMappingUse)
	ON_WM_SYSCOMMAND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LRESULT CMemoryDlg::OnFinishTest(WPARAM wParam, LPARAM lParam)
{	switch (wParam)
	{	case 0:	m_GlobalAllocTest.SetWindowText("Test");
				m_GlobalAllocUse.EnableWindow(TRUE);
				break;
		case 1: m_VirtualAllocTest.SetWindowText("Test");
				m_VirtualAllocUse.EnableWindow(TRUE);
				break;
		case 2: m_FileMappingTest.SetWindowText("Test");
				m_FileMappingUse.EnableWindow(TRUE);
				break;
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMemoryDlg message handlers

BOOL CMemoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	pSysMenu->EnableMenuItem(pSysMenu->GetMenuItemID(2), 1);
	pSysMenu->EnableMenuItem(pSysMenu->GetMenuItemID(4), 1);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_TestSecSpin.SetRange(1,60);	// Set TestSec spin parameters
	m_TestSecSpin.SetPos(5);

	m_WorkFileMapping.SetWindowText("0");	// Set starting fields
	m_WorkVirtualAlloc.SetWindowText("0");
	m_WorkGlobalAlloc.SetWindowText("0");

	m_TestGlobalAlloc.Dialog=this;

	// create and start thread for view of memory tate
	m_MyThread = (CMyThread*)
		AfxBeginThread(RUNTIME_CLASS(CMyThread), THREAD_PRIORITY_LOWEST,
			0, CREATE_SUSPENDED);
	m_MyThread->m_pOwner=this;
	m_MyThread->ResumeThread();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMemoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CMemoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMemoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// scan and view error
BOOL CMemoryDlg::ErrorMessage(int h, char *ch, BOOL ErrorNULL)
{	if (ErrorNULL && !h || !ErrorNULL && h)
	{	AfxMessageBox(ch,
					  MB_OK | MB_ICONERROR, 0);
		return TRUE;
	}
	else
		return FALSE;
}

// memory test thread
UINT TestThread(LPVOID pParam)
{	CTime		Time0, Time1;
	CTimeSpan	Time;
	CString		s;
	UINT		Res;

	TTest *Test=(TTest*)pParam;
	// wait next second
	Time0=CTime::GetCurrentTime();
	do
		Time1=CTime::GetCurrentTime();
	while (Time1==Time0);
	Time1=Time1+Test->Sec;

	Test->Result=0;
	UINT i=0;
	// memory test (copy bytes from beginning to ending)
	do
	{	Test->Mem[i]=i;
		Test->Mem[Test->Size-1-i]=Test->Mem[i];
		i++;
		if (i>=Test->Size)
			i=0;

		Test->Result++;
		Time0=CTime::GetCurrentTime();
	} while (Time0==Time1 || Time0<Time1 && !Test->ManualExit);

	// callc result (operation/sec)
	switch (Test->ManualExit)
	{	case TRUE:	Time=Time1-Time0;
					Test->Sec=Time.GetSeconds();
					Res=Test->Result/Time.GetSeconds();
					break;
		case FALSE:	Res=Test->Result/Test->Sec;
					break;
	}
	s.Format("%d movings byte per second", 
			 Res);
	s="Relative speed of operation with memory\n"+s;
	// view result
	switch (Test->Param)
	{	case 0:	::MessageBox(AfxGetMainWnd()->m_hWnd,
							 s, 
							 "Memory through GlobalAlloc",
							 MB_OK | MB_ICONINFORMATION);
				break;
		case 1:	::MessageBox(AfxGetMainWnd()->m_hWnd,
							 s, 
							 "Memory through VirtualAlloc",
							 MB_OK | MB_ICONINFORMATION);
				break;
		case 2:	::MessageBox(AfxGetMainWnd()->m_hWnd,
							 s, 
							 "Memory through FileMapping",
							 MB_OK | MB_ICONINFORMATION);
				break;
	}

	// eturning of buttons in a source state
	::SendMessage(AfxGetMainWnd()->m_hWnd, 
				  WM_STOPTEST, Test->Param, 0);

	return 0;
};

// beginning memory test
void CMemoryDlg::TestMem(TTest *Test)
{	UpdateData();
	Test->ManualExit=FALSE;
	Test->Sec=m_nTestSec;
	Test->Thread=AfxBeginThread(TestThread, 
								Test,
								THREAD_PRIORITY_NORMAL,
								4096);
};

// change GlobalAlloc size field
void CMemoryDlg::OnChangeGlobalAlloc() 
{	CString s;

	m_WorkGlobalAlloc.GetWindowText(s);
	if (atoi(s)>0)
		m_GlobalAllocReserve.EnableWindow(TRUE);
	else
		m_GlobalAllocReserve.EnableWindow(FALSE);
}

// press button Alloc/Free for GlobalAlloc 
void CMemoryDlg::OnGlobalAllocReserve() 
{	CString s;

	m_GlobalAllocReserve.GetWindowText(s);
	if (s=="Alloc")
	{	m_WorkGlobalAlloc.GetWindowText(s);
		m_hGlobalAlloc=GlobalAlloc(GMEM_MOVEABLE, atoi(s));
		if (!ErrorMessage((int)m_hGlobalAlloc, 
						  "C'not enought of memory!"))
		{	m_TestGlobalAlloc.Size=atoi(s);
			m_WorkGlobalAlloc.EnableWindow(FALSE);
			m_GlobalAllocUse.EnableWindow(TRUE);
			m_GlobalAllocReserve.SetWindowText("Free");
		}
	}
	else
	{	if (!ErrorMessage((int)GlobalFree(m_hGlobalAlloc),
		 				  "C'not free of memory!",
						  FALSE))
		{	m_WorkGlobalAlloc.EnableWindow(TRUE);
			m_GlobalAllocUse.EnableWindow(FALSE);
			m_GlobalAllocReserve.SetWindowText("Alloc");
		}
	}
}

// press button Test/Stop for GlobalAlloc 
void CMemoryDlg::OnGlobalAllocTest() 
{	CString s;
	
	m_GlobalAllocTest.GetWindowText(s);
	if (s=="Test")
	{	m_GlobalAllocTest.SetWindowText("Stop");
		m_GlobalAllocUse.EnableWindow(FALSE);

		m_TestGlobalAlloc.Param=0;
		TestMem(&m_TestGlobalAlloc);
	}
	else
	{	m_TestGlobalAlloc.ManualExit=TRUE;
		
		m_GlobalAllocTest.SetWindowText("Test");
		m_GlobalAllocUse.EnableWindow(TRUE);
	}
}

// press button Lock/Unlock GlobalAlloc 
void CMemoryDlg::OnGlobalAllocUse() 
{	CString s;
	
	m_GlobalAllocUse.GetWindowText(s);
	if (s=="Lock")
	{	m_TestGlobalAlloc.Mem=(BYTE *)GlobalLock(m_hGlobalAlloc);
		if (!ErrorMessage((int)m_TestGlobalAlloc.Mem, 
					  	 "C'not lock of memory!"))
		{	m_GlobalAllocUse.SetWindowText("Unlock");
			m_GlobalAllocReserve.EnableWindow(FALSE);
			m_GlobalAllocTest.EnableWindow(TRUE);
		}
	}
	else
	{	GlobalUnlock(m_hGlobalAlloc);
		m_GlobalAllocUse.SetWindowText("Lock");
		m_GlobalAllocReserve.EnableWindow(TRUE);
		m_GlobalAllocTest.EnableWindow(FALSE);
	}
}

// press button Alloc/Free for Virtualalloc 
void CMemoryDlg::OnVirtualAllocReserve() 
{	CString s;

	m_VirtualAllocReserve.GetWindowText(s);
	if (s=="Alloc")
	{	m_WorkVirtualAlloc.GetWindowText(s);
		m_pVirtualAlloc=VirtualAlloc(0, 
									 atoi(s), 
									 MEM_RESERVE,
									 PAGE_READWRITE);
		if (!ErrorMessage((int)m_pVirtualAlloc, 
						  "C'not enought of memory!"))
		{	m_TestVirtualAlloc.Size=atoi(s);
			m_WorkVirtualAlloc.EnableWindow(FALSE);
			m_VirtualAllocUse.EnableWindow(TRUE);
			m_VirtualAllocReserve.SetWindowText("Free");
		}
	}
	else
	{	if (!ErrorMessage((int)VirtualFree(m_pVirtualAlloc,
										   0,
										   MEM_RELEASE),
		 				  "C'not free of memory!"))
		{	m_WorkVirtualAlloc.EnableWindow(TRUE);
			m_VirtualAllocUse.EnableWindow(FALSE);
			m_VirtualAllocReserve.SetWindowText("Alloc");
		}
	}
}

// press button Lock/Unlock for VirtualAlloc 
void CMemoryDlg::OnVirtualAllocUse() 
{	CString s;
	
	m_VirtualAllocUse.GetWindowText(s);
	if (s=="Commit")
	{	m_WorkVirtualAlloc.GetWindowText(s);
		m_TestVirtualAlloc.Mem=(BYTE *)VirtualAlloc(m_pVirtualAlloc,
													atoi(s),
													MEM_COMMIT,
													PAGE_READWRITE);
		if (!ErrorMessage((int)m_TestVirtualAlloc.Mem, 
					  	 "C'not commit of memory!"))
		{	m_VirtualAllocUse.SetWindowText("Reserve");
			m_VirtualAllocReserve.EnableWindow(FALSE);
			m_VirtualAllocTest.EnableWindow(TRUE);
		}
	}
	else
	{	m_WorkVirtualAlloc.GetWindowText(s);
		VirtualAlloc(m_pVirtualAlloc,
					 atoi(s),
					 MEM_RESERVE,
					 PAGE_READWRITE);
		m_VirtualAllocUse.SetWindowText("Commit");
		m_VirtualAllocReserve.EnableWindow(TRUE);
		m_VirtualAllocTest.EnableWindow(FALSE);
	}
}

// press button Test/Stop for VirtualAlloc 
void CMemoryDlg::OnVirtualAllocTest() 
{	CString s;
	
	m_VirtualAllocTest.GetWindowText(s);
	if (s=="Test")
	{	m_VirtualAllocTest.SetWindowText("Stop");
		m_VirtualAllocUse.EnableWindow(FALSE);

		m_TestVirtualAlloc.Param=1;
		TestMem(&m_TestVirtualAlloc);
	}
	else
	{	m_TestVirtualAlloc.ManualExit=TRUE;
		
		m_VirtualAllocTest.SetWindowText("Test");
		m_VirtualAllocUse.EnableWindow(TRUE);
	}
}

// change VirtualAlloc size field
void CMemoryDlg::OnChangeVirtualAlloc() 
{	CString s;

	m_WorkVirtualAlloc.GetWindowText(s);
	if (atoi(s)>0)
		m_VirtualAllocReserve.EnableWindow(TRUE);
	else
		m_VirtualAllocReserve.EnableWindow(FALSE);
}

// press button Create/Close for FileMapping 
void CMemoryDlg::OnFileMappingReserve() 
{	CString s, name;
	CTime Time;

	m_FileMappingReserve.GetWindowText(s);
	if (s=="Create")
	{	Time=CTime::GetCurrentTime();
		name.Format("%d", Time);
		m_WorkFileMapping.GetWindowText(s);
		m_hFileMapping=CreateFileMapping((HANDLE)0xffffffff, 
										 NULL, 
										 PAGE_READWRITE | SEC_COMMIT,
										 0,
										 atoi(s),
										 "MEMORY"+name);
		if (!ErrorMessage((int)m_hFileMapping, 
						  "C'not open of file mapping!"))
		{	m_TestFileMapping.Size=atoi(s);
			m_WorkFileMapping.EnableWindow(FALSE);
			m_FileMappingUse.EnableWindow(TRUE);
			m_FileMappingReserve.SetWindowText("Close");
		}
	}
	else
	{	if (!ErrorMessage((int)CloseHandle(m_hFileMapping),
		 				  "C'not close of file mapping!"))
		{	m_WorkFileMapping.EnableWindow(TRUE);
			m_FileMappingUse.EnableWindow(FALSE);
			m_FileMappingReserve.SetWindowText("Create");
		}
	}
}

// change FileMapping size field
void CMemoryDlg::OnChangeFileMapping() 
{	CString s;

	m_WorkFileMapping.GetWindowText(s);
	if (atoi(s)>0)
		m_FileMappingReserve.EnableWindow(TRUE);
	else
		m_FileMappingReserve.EnableWindow(FALSE);
}

// press button FileMapping Test/Stop for FileMapping 
void CMemoryDlg::OnFileMappingTest() 
{	CString s;
	
	m_FileMappingTest.GetWindowText(s);
	if (s=="Test")
	{	m_FileMappingTest.SetWindowText("Stop");
		m_FileMappingUse.EnableWindow(FALSE);

		m_TestFileMapping.Param=2;
		TestMem(&m_TestFileMapping);
	}
	else
	{	m_TestFileMapping.ManualExit=TRUE;
		
		m_FileMappingTest.SetWindowText("Test");
		m_FileMappingUse.EnableWindow(TRUE);
	}
}

// press button Map/Unmap FileMapping 
void CMemoryDlg::OnFileMappingUse() 
{	CString s;
	
	m_FileMappingUse.GetWindowText(s);
	if (s=="Map")
	{	m_WorkFileMapping.GetWindowText(s);
		m_TestFileMapping.Mem=(BYTE *)MapViewOfFile(m_hFileMapping,
													FILE_MAP_WRITE,
													0, 0,
													atoi(s));
		if (!ErrorMessage((int)m_TestFileMapping.Mem, 
					  	  "C'not mapping of file!"))
		{	m_FileMappingUse.SetWindowText("Unmap");
			m_FileMappingReserve.EnableWindow(FALSE);
			m_FileMappingTest.EnableWindow(TRUE);
		}
	}
	else
	{	if (!ErrorMessage((int)UnmapViewOfFile(m_TestFileMapping.Mem),
						  "C'not unpmap of file!"))
		{	m_FileMappingUse.SetWindowText("Map");
			m_FileMappingReserve.EnableWindow(TRUE);
			m_FileMappingTest.EnableWindow(FALSE);
		}
	}
}
