#!/usr/bin/perl

# "logusers" from Sep 17 2000
# Log of site visitings
# Copyright  Pavel Korolyov, 2000 
# http://marabou.da.ru/

use Time::Local;

$notime=60*3;
$mintime=60*60*6;
$maxtime=60*60*24*183;
$maxsize=300000;
$statdel="statdel.txt";
$statmin="statmin.txt";
$statmax="statmax.txt";
$minold="statmin.old";
$maxold="statmax.old";
$maxtemp="statmax.tmp";
$mintemp="statmin.tmp";
$gmtvalue=4;

$ip = $ENV{'REMOTE_ADDR'};
$browser = $ENV{'HTTP_USER_AGENT'};
$language = $ENV{'HTTP_ACCEPT_LANGUAGE'};
$referer = $ENV{'HTTP_REFERER'};
@digits = split (/\./, $ip);
$addr = pack ("C4", @digits);
$host = gethostbyaddr ($addr, 2);
$rem=$ARGV[0];

@months = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

sub d2
{	return (length $_[0]>=2? $_[0]: "0"."$_[0]");
}

sub date 
{	$clock=time+$gmtvalue*60*60;
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($clock);
	$year+=1900;

   	return d2($mday)." @months[$mon] $year ".d2($hour).":".d2($min);
}

sub str2date
{	($mday_, $mon_, $year_, $hour_, $min_)=($_[0] =~ /m|(\d+) (\S+) (\d+) (\d+):(\d+)/);
	$i=0;
	foreach $item (@months)
	{	if ($item eq $mon_)
		{	$mon_=$i;
			last;
		}
		$i++;
	}

	return timelocal(0, $min_, $hour_, $mday_, $mon_, $year_);
}

sub writefile
{	print wfile "@_[0]\t@_[1]\t@_[2]\t@_[3]\t@_[4]\t@_[5]\t@_[6]\t@_[7]@_[8]"
			or die "Can't write @_[9] $!";
}

$time=date();
$ntime=str2date($time);

if (!$host)
{	$host=$ip;
}
@newfields=("$host", "$browser", "$language", "$referer", "$rem", "1", "$time", "$time");
#           0        1           2            3           4       5    6        7

open (rfile, "<$statmin") or die "Can't open $statmin $!";
while (<rfile>)
{	@fields=split(/\t/, $_);
	$nline=$.;
	
	$nfieldtime=str2date(@fields[7]);

	if (abs($ntime-$nfieldtime)>$mintime)
	{	open (rfile1, "<$statmax") or die "Can't open $statmax $!";
		rename($maxold, $maxtemp);
		open (wfile, ">$maxtemp") or die "Can't open $maxtemp $!";
		flock(wfile, 2) or die "Can't lock $maxtemp file $!";
		$deln=0;
		$maxdel=0;
		do
		{	$recdel=0;
			seek(rfile, 0, 0) or die "Can't seek $statmin $!";
			@amin=<rfile>;
			seek(rfile, 0, 0) or die "Can't seek $statmin $!";
			seek(rfile1, 0, 0) or die "Can't seek $statmax $!";
			seek(wfile, 0, 0) or die "Can't seek $maxtemp $!";
			truncate(wfile, 0) or die "Can't truncate $maxtemp $!";
			while (<rfile1>)
			{	@fields1=split(/\t/, $_) or die "Can't read $statmax $!";
 				$nfieldtime1=str2date(@fields1[7]);
 				if (@fields1[5]>$maxdel)
 				{	$maxdel=@fields1[5];
 				}
			
				if (abs($ntime-$nfieldtime1)<=$maxtime)
				{	if (@fields1[5]>$deln)
					{	$i=0;
						foreach $item1 (@amin)
						{	@item=split(/\t/, $item1);
							if ("@fields1[0]\t@fields1[1]\t@fields1[2]" eq
								"@item[0]\t@item[1]\t@item[2]")
							{	if (@amin>=1)
								{	@amin[$i]=@amin[$#amin];
									$#amin--;
								}
								if (@item[3])
								{	@fields1[3]=@item[3];
								}
								@fields1[5]+=@item[5];
								@fields1[7]=@item[7];
								last;
							}
							$i++;
						}
						writefile(@fields1, "", $maxtemp);
					}
					else
					{	$recdel++;
					}
				}
			}
			foreach $item1 (@amin)
			{	@item=split(/\t/, $item1);
				writefile(@item, "", $maxtemp);
			}
			if ($deln<$maxdel && tell(wfile)>$maxsize)
			{	$deln++;
			}
			else
			{	$deln=0;
			}
		}
		while ($deln);
		close wfile or die "Can't close $maxtemp $!";
		close rfile1;
		rename($statmax, $maxold) or die "Can't rename $statmax to $maxold $!";
		rename($maxtemp, $statmax) or die "Can't rename $maxtemp to $statmax $!";
		
		if ($recdel)
		{	open (wfile, ">$statdel") or die "Can't open $statdel $!";
			print wfile "From $statmax $recdel records is removed $time\n"
				or die "Can't write $statdel $!";
			close wfile;
		}
		
		close rfile;
		rename($statmin, $minold) or die "Can't rename $statmin to $minold $!";
		open (rfile, ">$statmin") or die "Can't open $statmin $!";
		close rfile;
		open (rfile, "<$statmin") or die "Can't open $statmin $!";
		last;
	}

	if ("@newfields[0]\t@newfields[1]\t@newfields[2]" eq 
		"@fields[0]\t@fields[1]\t@fields[2]")
	{	if (abs($ntime-$nfieldtime)<=$notime)
		{	close rfile;

			exit;
		}
		
		@fields[5]++;
 		@fields[7]=$time;

		rename($minold, $mintemp);
		open (wfile, ">$mintemp") or die "Can't open $mintemp $!";
		flock(wfile, 2) or die "Can't lock $mintemp file $!";
		seek(rfile, 0, 0) or die "Can't seek $statmin $!";
		$i=0;
		while (<rfile>)
		{	$item=$_;
			$i++;
			if ($i != $nline)
			{	print wfile "$item" or die "Can't write $mintemp $!";
			}
		}
		writefile(@fields, "\n", $mintemp);
		close wfile or die "Can't close $statmin $!";
		close rfile;
		rename($mintemp, $statmin) or die "Can't rename $mintemp to $statmin $!";

		exit;
	}
}
close rfile;

$firsttime=$time;
$count=1;
open (wfile, ">>$statmin") or die "Can't open $statmin $!";
writefile(@newfields, "\n", $statmin);
close wfile or die "Can't close $statmin $!";
